/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.formatterexpansion;

import ch.andre601.formatterexpansion.formatters.IFormatter;
import ch.andre601.formatterexpansion.formatters.number.NumberFormatter;
import ch.andre601.formatterexpansion.formatters.text.TextFormatter;
import ch.andre601.formatterexpansion.utils.StringUtils;
import ch.andre601.formatterexpansion.utils.logging.CachedWarnHelper;
import ch.andre601.formatterexpansion.utils.logging.LegacyLogger;
import ch.andre601.formatterexpansion.utils.logging.LoggerUtil;
import ch.andre601.formatterexpansion.utils.logging.NativeLogger;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.expansion.Configurable;
import me.clip.placeholderapi.expansion.NMSVersion;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;

public class FormatterExpansion
extends PlaceholderExpansion
implements Configurable {
    private final Map<String, Object> defaults = new HashMap<String, Object>();
    private final List<IFormatter> formatters;
    private final LoggerUtil logger = this.loadLogger();

    public FormatterExpansion() {
        this.loadDefaults();
        this.formatters = Arrays.asList(new NumberFormatter(this), new TextFormatter(this));
    }

    @Nonnull
    public String getIdentifier() {
        return "formatter";
    }

    @Nonnull
    public String getAuthor() {
        return "Andre_601";
    }

    @Nonnull
    public String getVersion() {
        return "2.9.1";
    }

    public Map<String, Object> getDefaults() {
        this.migrate();
        return this.defaults;
    }

    public String onRequest(OfflinePlayer player, @Nonnull String identifier) {
        String raw = "%formatter_" + identifier + "%";
        identifier = PlaceholderAPI.setBracketPlaceholders((OfflinePlayer)player, (String)identifier);
        String[] temp = StringUtils.getSplit(identifier, "_", 3);
        if (StringUtils.isNullOrEmpty(temp[0], temp[1])) {
            CachedWarnHelper.warn(this, raw, "Placeholder needs to be of format '%formatter_<type>_<option>_<values>%'");
            return null;
        }
        if (StringUtils.isNullOrEmpty(temp[2])) {
            return "";
        }
        for (IFormatter formatter : this.formatters) {
            if (!formatter.name().equalsIgnoreCase(temp[0])) continue;
            String[] values = (String[])Arrays.stream(temp[2].split("_")).map(entry -> entry.replace("{{u}}", "_").replace("{{prc}}", "%")).toArray(String[]::new);
            return formatter.parse(raw, temp[1], values);
        }
        CachedWarnHelper.warn(this, raw, "Unknown placeholder type '" + temp[0] + "'.");
        return null;
    }

    public boolean isCondensed() {
        Object condensed = this.get("time.condensed", null);
        if (condensed == null) {
            return false;
        }
        if (condensed instanceof String) {
            String condensedString = (String)condensed;
            return condensedString.equalsIgnoreCase("yes");
        }
        if (condensed instanceof Boolean) {
            Boolean condensedBool = (Boolean)condensed;
            return condensedBool;
        }
        return false;
    }

    public LoggerUtil loadLogger() {
        if (NMSVersion.getVersion((String)"v1_18_R1") != NMSVersion.UNKNOWN) {
            return new NativeLogger(this);
        }
        return new LegacyLogger();
    }

    public LoggerUtil getLogger() {
        return this.logger;
    }

    private void loadDefaults() {
        this.defaults.put("formatting.pattern", "#,###,###.##");
        this.defaults.put("formatting.locale", "en-US");
        this.defaults.put("shorten.thousands", "{{number}}K");
        this.defaults.put("shorten.millions", "{{number}}M");
        this.defaults.put("shorten.billions", "{{number}}B");
        this.defaults.put("shorten.trillions", "{{number}}T");
        this.defaults.put("shorten.quadrillions", "{{number}}Q");
        this.defaults.put("shorten.quintillions", "{{number}}Qi");
        this.defaults.put("shorten.sextillions", "{{number}}Sx");
        this.defaults.put("shorten.septillions", "{{number}}Sp");
        this.defaults.put("shorten.octillions", "{{number}}Oc");
        this.defaults.put("shorten.nonillions", "{{number}}No");
        this.defaults.put("shorten.decillions", "{{number}}Dc");
        this.defaults.put("shorten.pattern", "###.#");
        this.defaults.put("shorten.rounding_mode", "half-up");
        this.defaults.put("time.milliseconds", "{{number}}ms");
        this.defaults.put("time.seconds", "{{number}}s");
        this.defaults.put("time.minutes", "{{number}}m");
        this.defaults.put("time.hours", "{{number}}h");
        this.defaults.put("time.days", "{{number}}d");
        this.defaults.put("time.condensed", false);
        this.defaults.put("time.includeZeroDays", false);
        this.defaults.put("time.includeZeroHours", false);
        this.defaults.put("time.includeZeroMinutes", false);
        this.defaults.put("time.includeZeroSeconds", false);
        this.defaults.put("time.includeZeroMilliseconds", false);
        this.defaults.put("time.belowZeroOutput", "{{number}}");
        this.defaults.put("rounding.precision", 0);
        this.defaults.put("rounding.mode", "half-up");
    }

    private void migrate() {
        if (this.getString("format", null) == null) {
            return;
        }
        this.logger.info("Found old 'format' option. Attempting migration...");
        this.defaults.put("format", null);
        this.defaults.put("locale", null);
        this.defaults.put("formatting.pattern", this.getString("format", "#,###,###.##"));
        this.defaults.put("formatting.locale", this.getString("locale", "en-US"));
        this.logger.info("Migration completed! Please check the config.yml for any issues.");
    }
}

