/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.formatterexpansion.formatters.number;

import ch.andre601.formatterexpansion.FormatterExpansion;
import ch.andre601.formatterexpansion.formatters.IFormatter;
import ch.andre601.formatterexpansion.formatters.number.Format;
import ch.andre601.formatterexpansion.formatters.number.FromTo;
import ch.andre601.formatterexpansion.formatters.number.Round;
import ch.andre601.formatterexpansion.formatters.number.Shorten;
import ch.andre601.formatterexpansion.formatters.number.Time;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class NumberFormatter
implements IFormatter {
    private final List<IFormatter> subFormatters;
    private final FromTo fromToFormatter;

    public NumberFormatter(FormatterExpansion expansion) {
        this.subFormatters = Arrays.asList(new Format(expansion), new Round(expansion), new Shorten(expansion), new Time(expansion));
        this.fromToFormatter = new FromTo(expansion);
    }

    @Override
    public String name() {
        return "number";
    }

    @Override
    public String parse(String raw, String option, String ... values) {
        if (option.toLowerCase(Locale.ROOT).startsWith("from:")) {
            return this.fromToFormatter.parse(raw, option, values);
        }
        for (IFormatter subFormatter : this.subFormatters) {
            if (!subFormatter.name().equalsIgnoreCase(option)) continue;
            return subFormatter.parse(raw, option, values);
        }
        return null;
    }
}

