/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.formatterexpansion.formatters.number;

import ch.andre601.formatterexpansion.FormatterExpansion;
import ch.andre601.formatterexpansion.formatters.IFormatter;
import ch.andre601.formatterexpansion.utils.NumberUtils;
import ch.andre601.formatterexpansion.utils.StringUtils;
import ch.andre601.formatterexpansion.utils.logging.CachedWarnHelper;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;

public class Time
implements IFormatter {
    private final Map<String, String> units = new HashMap<String, String>();
    private final FormatterExpansion expansion;

    public Time(FormatterExpansion expansion) {
        this.expansion = expansion;
        this.units.put("days", expansion.getString("time.days", "{{number}}d"));
        this.units.put("hours", expansion.getString("time.hours", "{{number}}h"));
        this.units.put("minutes", expansion.getString("time.minutes", "{{number}}m"));
        this.units.put("seconds", expansion.getString("time.seconds", "{{number}}s"));
        this.units.put("milliseconds", expansion.getString("time.milliseconds", "{{number}}ms"));
    }

    @Override
    public String name() {
        return "time";
    }

    @Override
    public String parse(String raw, String option, String ... values) {
        if (values.length == 0) {
            CachedWarnHelper.warn(this.expansion, "length", raw, "Invalid placeholder format. Requires at least <number>!");
            return null;
        }
        TimeUnit unit = null;
        if (values.length >= 2) {
            unit = StringUtils.getTimeUnit(values[0]);
        }
        return this.formatTime(raw, StringUtils.merge(unit != null ? 1 : 0, "", values), unit != null ? unit : TimeUnit.SECONDS);
    }

    private String formatTime(String raw, String number, TimeUnit timeUnit) {
        Long finalNumber = NumberUtils.optLong(number);
        if (finalNumber == null) {
            CachedWarnHelper.warn(this.expansion, "long", raw, "Cannot convert " + number + " to a long.");
            return null;
        }
        if (finalNumber < 0L) {
            return this.returnBelowZeroOutput(finalNumber);
        }
        if (timeUnit == null) {
            CachedWarnHelper.warn(this.expansion, "timeunit", raw, "Unsupported time unit provided.");
            return null;
        }
        long days = 0L;
        long hours = 0L;
        long minutes = 0L;
        long seconds = 0L;
        long milliseconds = 0L;
        StringJoiner joiner = new StringJoiner(this.expansion.isCondensed() ? "" : " ");
        switch (timeUnit) {
            case HOURS: {
                days = timeUnit.toDays(finalNumber);
                hours = timeUnit.toHours(finalNumber) - days * 24L;
                break;
            }
            case MINUTES: {
                days = timeUnit.toDays(finalNumber);
                hours = timeUnit.toHours(finalNumber) - days * 24L;
                minutes = timeUnit.toMinutes(finalNumber) - hours * 60L - days * 1440L;
                break;
            }
            case SECONDS: {
                days = timeUnit.toDays(finalNumber);
                hours = timeUnit.toHours(finalNumber) - days * 24L;
                minutes = timeUnit.toMinutes(finalNumber) - hours * 60L - days * 1440L;
                seconds = timeUnit.toSeconds(finalNumber) - minutes * 60L - hours * 3600L - days * 86400L;
                break;
            }
            case MILLISECONDS: {
                days = timeUnit.toDays(finalNumber);
                hours = timeUnit.toHours(finalNumber) - days * 24L;
                minutes = timeUnit.toMinutes(finalNumber) - hours * 60L - days * 1440L;
                seconds = timeUnit.toSeconds(finalNumber) - minutes * 60L - hours * 3600L - days * 86400L;
                milliseconds = finalNumber - seconds * 1000L - minutes * 60000L - hours * 3600000L - days * 86400000L;
            }
        }
        if (days > 0L || days == 0L && this.expansion.getBoolean("time.includeZeroDays", false)) {
            joiner.add(this.getUnitText(this.units.get("days")).replace("{{number}}", String.valueOf(days)));
        }
        if (hours > 0L || hours == 0L && this.expansion.getBoolean("time.includeZeroHours", false)) {
            joiner.add(this.getUnitText(this.units.get("hours")).replace("{{number}}", String.valueOf(hours)));
        }
        if (minutes > 0L || minutes == 0L && this.expansion.getBoolean("time.includeZeroMinutes", false)) {
            joiner.add(this.getUnitText(this.units.get("minutes")).replace("{{number}}", String.valueOf(minutes)));
        }
        if (seconds > 0L || seconds == 0L && this.expansion.getBoolean("time.includeZeroSeconds", false)) {
            joiner.add(this.getUnitText(this.units.get("seconds")).replace("{{number}}", String.valueOf(seconds)));
        }
        if (milliseconds > 0L || milliseconds == 0L && this.expansion.getBoolean("time.includeZeroMilliseconds", false)) {
            joiner.add(this.getUnitText(this.units.get("milliseconds")).replace("{{number}}", String.valueOf(milliseconds)));
        }
        return joiner.toString();
    }

    private String getUnitText(String text) {
        return text.toLowerCase(Locale.ROOT).contains("{{number}}") ? text : "{{number}}" + text;
    }

    private String returnBelowZeroOutput(long number) {
        return switch (this.expansion.getString("time.belowZeroOutput", "{{number}}")) {
            case "{{number}}" -> String.valueOf(number);
            case "null" -> null;
            default -> this.expansion.getString("time.belowZeroOutput", "{{number}}");
        };
    }
}

