/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.formatterexpansion.formatters.text;

import ch.andre601.formatterexpansion.FormatterExpansion;
import ch.andre601.formatterexpansion.formatters.IFormatter;
import ch.andre601.formatterexpansion.utils.StringUtils;
import ch.andre601.formatterexpansion.utils.logging.CachedWarnHelper;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Replace
implements IFormatter {
    private final FormatterExpansion expansion;

    public Replace(FormatterExpansion expansion) {
        this.expansion = expansion;
    }

    @Override
    public String name() {
        return "replace";
    }

    @Override
    public String parse(String raw, String option, String ... values) {
        if (values.length < 3) {
            CachedWarnHelper.warn(this.expansion, "length", raw, "Placeholder does not have a [target], [replacement] and text value.");
            return null;
        }
        String target = values[0];
        String replacement = values[1];
        String text = StringUtils.merge(2, "_", values);
        if (target.toLowerCase(Locale.ROOT).startsWith("{{r=") && target.toLowerCase(Locale.ROOT).endsWith("}}")) {
            int start = target.indexOf(61);
            int end = target.lastIndexOf(125);
            if (start < 3) {
                CachedWarnHelper.warn(this.expansion, "reg-start", raw, "Invalid start index of '=' for Regex Pattern '" + target + "'. Expected at least 3, but got " + start + ".");
                return null;
            }
            if (end <= 3 || end < start + 1) {
                CachedWarnHelper.warn(this.expansion, "reg-end", raw, "Invalid end index of '}}' for Regex Pattern '" + target + "'. Expected at least 4, but got " + end + ".");
                return null;
            }
            Matcher matcher = Pattern.compile(target.substring(start + 1, end - 1)).matcher(text);
            if (matcher.find()) {
                StringBuilder builder = new StringBuilder(text.length());
                do {
                    matcher.appendReplacement(builder, replacement);
                } while (matcher.find());
                matcher.appendTail(builder);
                text = builder.toString();
            }
            return text;
        }
        return StringUtils.merge(2, "_", values).replace(target, replacement);
    }
}

