/*
 * Decompiled with CFR 0.152.
 */
package ch.andre601.formatterexpansion.utils.logging;

import ch.andre601.formatterexpansion.FormatterExpansion;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.concurrent.TimeUnit;

public class CachedWarnHelper {
    private static final Cache<String, String> cachedWarns = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.SECONDS).build();

    public static void warn(FormatterExpansion expansion, String placeholder, String msg) {
        CachedWarnHelper.warn(expansion, "", placeholder, msg);
    }

    public static void warn(FormatterExpansion expansion, String suffix, String placeholder, String msg) {
        String identifier = placeholder + (String)(suffix.isEmpty() ? "" : "." + suffix);
        if (cachedWarns.getIfPresent((Object)identifier) != null) {
            return;
        }
        cachedWarns.put((Object)identifier, (Object)placeholder);
        expansion.getLogger().warn("Invalid placeholder " + placeholder);
        expansion.getLogger().warn(msg);
    }
}

