/*
 * Decompiled with CFR 0.152.
 */
package io.github.tanguygab.playerlistexpansion;

import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public enum ListType {
    ONLINE(() -> Bukkit.getServer().getOnlinePlayers()),
    OFFLINE(() -> Arrays.stream(Bukkit.getServer().getOfflinePlayers()).filter(p -> !p.isOnline()).collect(Collectors.toList())),
    ALL(() -> Arrays.asList(Bukkit.getServer().getOfflinePlayers())),
    CUSTOM;

    Callable<Collection<? extends OfflinePlayer>> callable;

    private ListType() {
    }

    private ListType(Callable<Collection<? extends OfflinePlayer>> callable) {
        this.callable = callable;
    }

    public Collection<? extends OfflinePlayer> getList() {
        try {
            return this.callable.call();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static ListType find(String str) {
        if (str == null) {
            return null;
        }
        str = str.toUpperCase();
        for (ListType type : ListType.values()) {
            if (!type.toString().equals(str)) continue;
            return type;
        }
        return null;
    }
}

