/*
 * Decompiled with CFR 0.152.
 */
package io.github.tanguygab.playerlistexpansion;

import io.github.tanguygab.playerlistexpansion.CachedList;
import io.github.tanguygab.playerlistexpansion.ListType;
import io.github.tanguygab.playerlistexpansion.PlayerListExpansion;
import io.github.tanguygab.playerlistexpansion.filters.Filter;
import io.github.tanguygab.playerlistexpansion.sorting.SortingType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class PlayerList {
    private final String name;
    private final ListType type;
    private final List<Filter> filters;
    private final List<SortingType> sortingTypes;
    private final boolean included;
    private final boolean duplicates;
    private final Map<OfflinePlayer, CachedList> lastUpdate = new WeakHashMap<OfflinePlayer, CachedList>();

    public PlayerList(String name, ListType type, List<Filter> filters, List<SortingType> sortingTypes, boolean included, boolean duplicates) {
        this.name = name;
        this.type = type;
        this.filters = filters;
        this.sortingTypes = sortingTypes;
        this.included = included;
        this.duplicates = duplicates;
    }

    public String getText(OfflinePlayer viewer, String arguments) {
        int pos;
        String[] args = arguments.split("_");
        String format = PlayerListExpansion.get().getFormat(arguments, args);
        String arg = args[0];
        List<String> names = this.lastUpdate.computeIfAbsent(viewer, k -> new CachedList(this::getList)).getList(viewer, format);
        if (arg.equals("amount")) {
            return "" + names.size();
        }
        if (arg.startsWith("list")) {
            String separator = arg.startsWith("list-") ? arg.substring(5).replace("\\n", "\n") : ", ";
            return String.join((CharSequence)separator, names);
        }
        try {
            pos = Integer.parseInt(arg);
        }
        catch (Exception e) {
            return null;
        }
        return pos >= 0 && pos < names.size() ? names.get(pos) : PlayerListExpansion.get().offlineText;
    }

    public List<String> getList(OfflinePlayer viewer, String format) {
        Stream<String> stream;
        if (this.type == ListType.CUSTOM) {
            String input = PlaceholderAPI.setPlaceholders((OfflinePlayer)viewer, (String)PlayerListExpansion.get().getString("lists." + this.name + ".input", ""));
            if (input.isEmpty()) {
                stream = Stream.of(new String[0]);
            } else {
                String separator = PlayerListExpansion.get().getString("lists." + this.name + ".separator", ",");
                stream = Stream.of(input.split(separator));
            }
        } else {
            stream = this.type.getList().stream().map(OfflinePlayer::getName);
        }
        stream = this.filter(viewer, format, stream);
        return this.sort(stream.collect(Collectors.toList()), viewer);
    }

    private Stream<String> filter(OfflinePlayer viewer, String format, Stream<String> stream) {
        if (!this.included) {
            stream = stream.filter(name -> !name.equals(viewer.getName()));
        }
        if (!this.duplicates) {
            stream = stream.distinct();
        }
        stream = stream.filter(name -> this.filters.stream().noneMatch(filter -> filter.isInverted() == filter.filter((String)name, viewer)));
        stream = stream.map(name -> {
            OfflinePlayer player = Bukkit.getOfflinePlayer((String)name);
            if (!player.hasPlayedBefore() && !player.isOnline()) {
                return name;
            }
            return PlaceholderAPI.setBracketPlaceholders((OfflinePlayer)player, (String)format);
        });
        return stream;
    }

    private List<String> sort(List<String> list, OfflinePlayer viewer) {
        if (this.sortingTypes.isEmpty()) {
            return list;
        }
        TreeMap sortedMap = new TreeMap();
        list.forEach(name -> {
            StringBuilder sortingString = new StringBuilder();
            this.sortingTypes.forEach(type -> sortingString.append(type.getSortingString((String)name, viewer)));
            sortedMap.computeIfAbsent(sortingString.toString(), k -> new ArrayList()).add(name);
        });
        return sortedMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

