/*
 * Decompiled with CFR 0.152.
 */
package io.github.tanguygab.playerlistexpansion;

import io.github.tanguygab.playerlistexpansion.ListType;
import io.github.tanguygab.playerlistexpansion.PlayerList;
import io.github.tanguygab.playerlistexpansion.filters.Filter;
import io.github.tanguygab.playerlistexpansion.groups.GroupedList;
import io.github.tanguygab.playerlistexpansion.groups.ListGroup;
import io.github.tanguygab.playerlistexpansion.sorting.SortingType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import me.clip.placeholderapi.expansion.Configurable;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import me.clip.placeholderapi.expansion.Taskable;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.ConfigurationSection;
import org.jetbrains.annotations.NotNull;

public class PlayerListExpansion
extends PlaceholderExpansion
implements Taskable,
Configurable {
    private static final Pattern FORMAT_PATTERN = Pattern.compile("_format:");
    private static PlayerListExpansion instance;
    private final Map<String, PlayerList> lists = new HashMap<String, PlayerList>();
    private final Map<String, ListGroup> listGroups = new HashMap<String, ListGroup>();
    private final List<String> placeholders = new ArrayList<String>();
    public int updateCooldown;
    public String offlineText;
    public String argumentSeparator;
    private static final Map<String, Object> defaults;

    public PlayerListExpansion() {
        instance = this;
    }

    public static PlayerListExpansion get() {
        return instance;
    }

    @NotNull
    public String getAuthor() {
        return "Tanguygab";
    }

    @NotNull
    public String getIdentifier() {
        return "playerlist";
    }

    @NotNull
    public String getVersion() {
        return "3.1.0";
    }

    @NotNull
    public List<String> getPlaceholders() {
        return this.placeholders;
    }

    public void start() {
        this.updateCooldown = this.getInt("update-cooldown", 1000);
        this.offlineText = this.getString("offline-text", "Offline");
        this.argumentSeparator = Pattern.quote(this.getString("argument-separator", ","));
        ConfigurationSection config = this.getConfigSection("lists");
        if (config == null) {
            return;
        }
        config.getValues(false).forEach((list, obj) -> {
            ConfigurationSection cfg = this.getConfigSection("lists." + list);
            if (cfg == null) {
                return;
            }
            String type0 = cfg.getString("type", "ONLINE");
            ListType type = ListType.find(type0);
            if (type == null) {
                this.log(Level.CONFIG, "List \"" + list + "\" has an invalid type \"" + type0 + "\"! Skipping...");
                return;
            }
            boolean included = cfg.getBoolean("included", true);
            boolean duplicates = cfg.getBoolean("duplicates", true);
            ArrayList<Filter> filters = new ArrayList<Filter>();
            cfg.getStringList("filters").forEach(filter -> {
                Filter f = Filter.find(filter);
                if (f == null) {
                    this.log(Level.CONFIG, "List \"" + list + "\" has an invalid filter type \"" + filter + "\"! Skipping...");
                    return;
                }
                filters.add(f);
            });
            ArrayList<SortingType> sortingTypes = new ArrayList<SortingType>();
            cfg.getStringList("sorting-types").forEach(sortingType -> {
                SortingType s = SortingType.find(sortingType);
                if (s == null) {
                    this.log(Level.CONFIG, "List \"" + list + "\" has an invalid sorting type \"" + sortingType + "\"! Skipping...");
                    return;
                }
                sortingTypes.add(s);
            });
            this.lists.put((String)list, new PlayerList((String)list, type, (List<Filter>)filters, (List<SortingType>)sortingTypes, included, duplicates));
        });
        this.placeholders.addAll(this.lists.keySet().stream().map(listName -> "%playerlist_" + listName + "_<list|amount|#>%").collect(Collectors.toList()));
        ConfigurationSection groups = this.getConfigSection("groups");
        if (groups == null) {
            return;
        }
        groups.getValues(false).forEach((group, obj) -> {
            ConfigurationSection cfg = this.getConfigSection("groups." + group);
            if (cfg == null) {
                return;
            }
            int gap = Math.max(0, cfg.getInt("gap", 1));
            ConfigurationSection listsCfg = cfg.getConfigurationSection("lists");
            if (listsCfg == null || listsCfg.getValues(false).isEmpty()) {
                this.log(Level.CONFIG, "Group \"" + group + "\" is empty! Skipping...");
                return;
            }
            ArrayList<GroupedList> lists = new ArrayList<GroupedList>();
            listsCfg.getValues(false).forEach((list, settings0) -> {
                if (!this.lists.containsKey(list)) {
                    this.log(Level.CONFIG, "List \"" + list + "\" in group \"" + group + "\" doesn't exist! Skipping...");
                    return;
                }
                ConfigurationSection settings = (ConfigurationSection)settings0;
                String title = settings.getString("title", list + " (%amount%)");
                int max = Math.max(0, settings.getInt("max", 0));
                String remaining = settings.getString("remaining");
                lists.add(new GroupedList(this.lists.get(list), title, max, remaining));
            });
            if (lists.isEmpty()) {
                this.log(Level.CONFIG, "Group \"" + group + "\" is empty! Skipping...");
                return;
            }
            this.listGroups.put((String)group, new ListGroup(lists, gap));
        });
        this.placeholders.addAll(this.listGroups.keySet().stream().map(groupName -> "%playerlist_group_" + groupName + "_<amount|#>%").collect(Collectors.toList()));
    }

    public void stop() {
    }

    public String onRequest(OfflinePlayer player, @NotNull String params) {
        Matcher matcher = FORMAT_PATTERN.matcher(params);
        String _params = matcher.find() ? params.substring(0, matcher.start()) : params;
        int _index = _params.lastIndexOf(95);
        if (_index == -1 || _index == params.length() - 1) {
            return null;
        }
        String list = params.substring(0, _index);
        String output = params.substring(_index + 1);
        if (list.startsWith("group_")) {
            String group = list.substring(6);
            ListGroup groupedList = this.listGroups.get(group);
            return groupedList != null ? groupedList.getText(player, output) : null;
        }
        PlayerList playerList = this.lists.get(list);
        return playerList != null ? playerList.getText(player, output) : null;
    }

    public Map<String, Object> getDefaults() {
        return defaults;
    }

    public String getFormat(String arg, String[] args) {
        if (args.length < 2) {
            return "{player_name}";
        }
        String argument = arg.substring(args[0].length() + 1);
        return argument.startsWith("format:") ? argument.substring(7) : "{player_name}";
    }

    static {
        defaults = new LinkedHashMap<String, Object>(){
            {
                this.put("update-cooldown", 1000);
                this.put("offline-text", "Offline");
                this.put("argument-separator", ",");
                this.put("lists", new HashMap<String, Map<String, Object>>(){
                    {
                        LinkedHashMap<String, Object> staffList = new LinkedHashMap<String, Object>(){
                            {
                                this.put("type", "ONLINE");
                                this.put("included", true);
                                this.put("filters", Arrays.asList("PERMISSION:group.staff", "CANSEE"));
                            }
                        };
                        this.put("staff", staffList);
                        LinkedHashMap<String, Object> playersList = new LinkedHashMap<String, Object>(){
                            {
                                this.put("type", "ONLINE");
                                this.put("included", true);
                                this.put("filters", Arrays.asList("!PERMISSION:group.staff", "CANSEE"));
                            }
                        };
                        this.put("players", playersList);
                    }
                });
                this.put("groups", new HashMap<String, Map<String, Object>>(){
                    {
                        LinkedHashMap<String, Object> playerlistGroup = new LinkedHashMap<String, Object>(){
                            {
                                this.put("gap", 1);
                                LinkedHashMap<String, Object> lists = new LinkedHashMap<String, Object>(){
                                    {
                                        LinkedHashMap<String, Object> staffList = new LinkedHashMap<String, Object>(){
                                            {
                                                this.put("title", "Staff Members (%amount%)");
                                                this.put("max", 10);
                                                this.put("remaining", "... and %remaining% more!");
                                            }
                                        };
                                        this.put("staff", staffList);
                                        LinkedHashMap<String, Object> playersList = new LinkedHashMap<String, Object>(){
                                            {
                                                this.put("title", "Players (%amount%)");
                                            }
                                        };
                                        this.put("players", playersList);
                                    }
                                };
                                this.put("lists", lists);
                            }
                        };
                        this.put("staffAndPlayers", playerlistGroup);
                    }
                });
            }
        };
    }
}

