/*
 * Decompiled with CFR 0.152.
 */
package io.github.tanguygab.playerlistexpansion.filters;

import io.github.tanguygab.playerlistexpansion.PlayerListExpansion;
import io.github.tanguygab.playerlistexpansion.filters.Banned;
import io.github.tanguygab.playerlistexpansion.filters.CanSee;
import io.github.tanguygab.playerlistexpansion.filters.GameMode;
import io.github.tanguygab.playerlistexpansion.filters.Nearby;
import io.github.tanguygab.playerlistexpansion.filters.Permission;
import io.github.tanguygab.playerlistexpansion.filters.Placeholder;
import io.github.tanguygab.playerlistexpansion.filters.Version;
import io.github.tanguygab.playerlistexpansion.filters.Whitelisted;
import io.github.tanguygab.playerlistexpansion.filters.World;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public abstract class Filter {
    private boolean inverted = false;
    private static final Map<String, Function<String, Filter>> filters = new HashMap<String, Function<String, Filter>>(){
        {
            this.put("BANNED", arg -> new Banned());
            this.put("CANSEE", arg -> new CanSee());
            this.put("GAMEMODE", GameMode::new);
            this.put("NEARBY", Nearby::new);
            this.put("PERMISSION", Permission::new);
            this.put("PLACEHOLDER", Placeholder::new);
            if (Bukkit.getServer().getPluginManager().isPluginEnabled("ViaVersion")) {
                this.put("VERSION", Version::new);
            }
            this.put("WHITELISTED", arg -> new Whitelisted());
            this.put("WORLD", World::new);
        }
    };

    public static Filter find(String string) {
        boolean inverted;
        int index = string.indexOf(":");
        String filter = index == -1 ? string : string.substring(0, index);
        filter = filter.toUpperCase();
        String arg = index == -1 ? null : string.substring(index + 1);
        boolean bl = inverted = filter.charAt(0) == '!';
        if (inverted) {
            filter = filter.substring(1);
        }
        if (filters.containsKey(filter)) {
            Filter f = filters.get(filter).apply(arg);
            f.inverted = inverted;
            return f;
        }
        return null;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    protected String[] split(String arg) {
        return arg.split(PlayerListExpansion.get().argumentSeparator);
    }

    protected OfflinePlayer getOffline(String name) {
        if (name == null) {
            return null;
        }
        return Bukkit.getServer().getOfflinePlayerIfCached(name);
    }

    protected Player getOnline(String name) {
        return Bukkit.getServer().getPlayerExact(name);
    }

    public abstract boolean filter(String var1, OfflinePlayer var2);
}

