/*
 * Decompiled with CFR 0.152.
 */
package io.github.tanguygab.playerlistexpansion.groups;

import io.github.tanguygab.playerlistexpansion.PlayerListExpansion;
import io.github.tanguygab.playerlistexpansion.groups.GroupedList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.OfflinePlayer;

public class ListGroup {
    private final List<GroupedList> lists;
    private final int gap;

    public ListGroup(List<GroupedList> lists, int gap) {
        this.lists = lists;
        this.gap = gap;
    }

    public String getText(OfflinePlayer viewer, String arguments) {
        int pos;
        String[] args = arguments.split("_");
        String format = PlayerListExpansion.get().getFormat(arguments, args);
        String arg = args[0];
        List<String> slots = this.getList(viewer, arg.equals("amount"), format);
        if (arg.equals("amount")) {
            return "" + slots.size();
        }
        try {
            pos = Integer.parseInt(arg);
        }
        catch (Exception e) {
            return null;
        }
        return pos >= 0 && pos < slots.size() ? slots.get(pos) : "";
    }

    private List<String> getList(OfflinePlayer viewer, boolean amount, String format) {
        ArrayList<String> slots = new ArrayList<String>();
        for (GroupedList list : this.lists) {
            List<String> players = list.getList().getList(viewer, format);
            if (players.isEmpty()) continue;
            if (amount) {
                slots.addAll(players);
                continue;
            }
            if (!slots.isEmpty() && this.gap != 0) {
                slots.addAll(Collections.nCopies(this.gap, ""));
            }
            slots.add(this.setPlaceholders(viewer, list.getTitle(), "%amount%", players.size()));
            if (list.getMax() > 0 && players.size() > list.getMax()) {
                for (int i = 0; i < list.getMax(); ++i) {
                    slots.add(players.get(i));
                }
                slots.add(this.setPlaceholders(viewer, list.getRemaining(), "%remaining%", players.size() - list.getMax()));
                continue;
            }
            slots.addAll(players);
        }
        return slots;
    }

    private String setPlaceholders(OfflinePlayer viewer, String string, String placeholder, int amount) {
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)viewer, (String)string.replace(placeholder, "" + amount));
    }
}

