/*
 * Decompiled with CFR 0.152.
 */
package io.github.tanguygab.playerlistexpansion.sorting;

import io.github.tanguygab.playerlistexpansion.sorting.A_TO_Z;
import io.github.tanguygab.playerlistexpansion.sorting.HIGH_TO_LOW;
import io.github.tanguygab.playerlistexpansion.sorting.LOW_TO_HIGH;
import io.github.tanguygab.playerlistexpansion.sorting.PLACEHOLDER;
import io.github.tanguygab.playerlistexpansion.sorting.Z_TO_A;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import me.clip.placeholderapi.PlaceholderAPI;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;

public abstract class SortingType {
    private static final Map<String, Function<String, SortingType>> types = new HashMap<String, Function<String, SortingType>>(){
        {
            this.put("A_TO_Z", A_TO_Z::new);
            this.put("Z_TO_A", Z_TO_A::new);
            this.put("LOW_TO_HIGH", LOW_TO_HIGH::new);
            this.put("HIGH_TO_LOW", HIGH_TO_LOW::new);
            this.put("PLACEHOLDER", PLACEHOLDER::new);
        }
    };
    protected static final int DEFAULT_NUMBER = 0x3FFFFFFF;
    private final String placeholder;

    public static SortingType find(String string) {
        int index = string.indexOf(":");
        String type = index == -1 ? string : string.substring(0, index);
        type = type.toUpperCase();
        String arg = index == -1 ? null : string.substring(index + 1);
        return types.containsKey(type) ? types.get(type).apply(arg) : null;
    }

    protected SortingType(String placeholder) {
        this.placeholder = placeholder;
    }

    protected String parse(String name, OfflinePlayer viewer) {
        if (this.placeholder == null || this.placeholder.isEmpty()) {
            return name;
        }
        if (!this.placeholder.contains("%")) {
            return this.placeholder;
        }
        String output = this.placeholder;
        Player onlinePlayer = Bukkit.getPlayerExact((String)name);
        if (onlinePlayer != null && viewer.getPlayer() != null) {
            output = PlaceholderAPI.setRelationalPlaceholders((Player)viewer.getPlayer(), (Player)onlinePlayer, (String)output);
        }
        output = PlaceholderAPI.setPlaceholders((OfflinePlayer)(onlinePlayer == null ? this.getOffline(name) : onlinePlayer), (String)output);
        return output;
    }

    protected OfflinePlayer getOffline(String name) {
        for (OfflinePlayer player : Bukkit.getServer().getOfflinePlayers()) {
            if (!name.equals(player.getName())) continue;
            return player;
        }
        return null;
    }

    protected double parseDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception e) {
            return 0.0;
        }
    }

    public abstract String getSortingString(String var1, OfflinePlayer var2);
}

