/*
 * Decompiled with CFR 0.152.
 */
package com.andre601.shortcut;

import com.andre601.shortcut.logger.LegacyLogger;
import com.andre601.shortcut.logger.LoggerWrapper;
import com.andre601.shortcut.logger.NativeLogger;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import java.util.StringJoiner;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.Cacheable;
import me.clip.placeholderapi.expansion.NMSVersion;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.OfflinePlayer;

public class Shortcut
extends PlaceholderExpansion
implements Cacheable {
    private final File folder = new File(String.valueOf(PlaceholderAPIPlugin.getInstance().getDataFolder()) + "/shortcuts/");
    private final Cache<String, String> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private final Pattern replacementPattern = Pattern.compile("\\{(\\d+)}");
    private final LoggerWrapper logger = this.loadLogger();
    private LastLog lastLog = null;

    public Shortcut() {
        if (this.folder.mkdirs()) {
            this.logger.info("Created shortcuts folder.");
        }
    }

    @Nonnull
    public String getIdentifier() {
        return "shortcut";
    }

    @Nonnull
    public String getAuthor() {
        return "Andre_601";
    }

    @Nonnull
    public String getVersion() {
        return "1.4.0";
    }

    public void clear() {
        this.cache.invalidateAll();
    }

    public String onRequest(OfflinePlayer player, @Nonnull String params) {
        String rawText;
        String[] values = params.split(":");
        if (values.length == 0) {
            return "ERR: Invalid Placeholder pattern received!";
        }
        String filename = values[0] + (values[0].toLowerCase(Locale.ROOT).endsWith(".txt") ? "" : ".txt");
        try {
            Path path = Paths.get(this.folder.getName(), filename).normalize();
            if (!path.startsWith("shortcuts" + File.separator)) {
                return "ERR: Invalid File Path!";
            }
            rawText = (String)this.cache.get((Object)filename.toLowerCase(Locale.ROOT), () -> {
                String string;
                block10: {
                    File file = new File(this.folder, filename);
                    if (!file.exists()) {
                        return "ERR: No file with name " + filename + " exists!";
                    }
                    BufferedReader reader = Files.newBufferedReader(file.toPath());
                    try {
                        String line;
                        StringJoiner joiner = new StringJoiner("\n");
                        while ((line = reader.readLine()) != null) {
                            joiner.add(line);
                        }
                        string = joiner.toString();
                        if (reader == null) break block10;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (reader != null) {
                                try {
                                    reader.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (IOException ex) {
                            this.sendCachedWarn("Encountered IOException while reading file " + file.getName() + "!", ex);
                            return "ERR: IOException on file read: " + ex.getMessage();
                        }
                    }
                    reader.close();
                }
                return string;
            });
        }
        catch (Exception ex) {
            this.sendCachedWarn("Encountered an Exception while handling input " + filename + "!", ex);
            return "ERR: Exception during Cache get: " + ex.getMessage();
        }
        if (rawText == null) {
            return "ERR: No text was retrieved from file " + filename + "!";
        }
        if (rawText.isEmpty()) {
            return rawText;
        }
        if (values.length == 1) {
            return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)rawText);
        }
        return this.parseReplacements(player, rawText, Arrays.copyOfRange(values, 1, values.length));
    }

    private String parseReplacements(OfflinePlayer player, String text, String[] values) {
        if (values.length == 0) {
            return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)text);
        }
        Matcher replacementMatcher = this.replacementPattern.matcher(text);
        String newText = text;
        if (replacementMatcher.find()) {
            StringBuilder buffer = new StringBuilder();
            do {
                int index;
                try {
                    index = Integer.parseInt(replacementMatcher.group(1));
                }
                catch (NumberFormatException ex) {
                    continue;
                }
                if (index < 0 || index + 1 > values.length) continue;
                replacementMatcher.appendReplacement(buffer, values[index]);
            } while (replacementMatcher.find());
            replacementMatcher.appendTail(buffer);
            newText = buffer.toString();
        }
        return PlaceholderAPI.setPlaceholders((OfflinePlayer)player, (String)newText);
    }

    private LoggerWrapper loadLogger() {
        if (NMSVersion.getVersion((String)"v1_18_R1") != NMSVersion.UNKNOWN) {
            return new NativeLogger(this);
        }
        return new LegacyLogger();
    }

    private void sendCachedWarn(String msg, Exception ex) {
        if (this.lastLog != null && !this.lastLog.isExpired()) {
            return;
        }
        this.lastLog = new LastLog();
        this.logger.warn(msg, ex);
    }

    private static class LastLog {
        private final long timestamp = System.currentTimeMillis();

        public boolean isExpired() {
            return System.currentTimeMillis() - this.timestamp > 10000L;
        }
    }
}

